#!/bin/bash

BASE_PATH=`dirname $0`
BASE_PATH=`cd ${BASE_PATH};pwd`

# Print error messges eg:  _err "This is error"
function _err()
{
    echo -e "\033[1;31m[ERROR] $@\033[0m" >&2
}
# Print notice messages eg: _info "This is Info"
function _info()
{
    echo -e "\033[1;32m[INFO] $@\033[0m" >&1
}

# Print tips messages eg: _tips "This is Tips"
function _tips()
{
    echo -e "\033[1;33m[TIPS] $@\033[0m"
}

CONN_SET_FILE="$BASE_PATH/all_con_20190812.ip"
if [ -f $BASE_PATH/tcpport_mon ];then
    chmod o+x $BASE_PATH/tcpport_mon
fi

if [ -f $BASE_PATH/conn_test.info ];then
    echo > $BASE_PATH/conn_test.info
else
    touch $BASE_PATH/conn_test.info
fi

while read line
do
	if [ -z "$line" ];then
		continue;
	fi
	{
		is_connect_ok=$($BASE_PATH/tcpport_mon $line 9988 2>&1 | grep "connect ok" | wc -l)
		[ $is_connect_ok -eq 1 ] && { 
            echo "$line " >> $BASE_PATH/conn_test.info
            _info "$line:9988 connect ok"
        }
	}& 
done < $CONN_SET_FILE

sleep 1

CONN_NUM=`cat $BASE_PATH/conn_test.info | grep -v ^$ | grep -v grep|wc -l`
if [ $CONN_NUM -eq 1 ];then
    _tips "网络正常，但是只有一台洋葱server可以连接，稳定期间建议至少可以连接大于等于2台，可参考readme.txt 配置网络或搭建代理"
    _tips "The network is normal, but only one onion server can be connected. It is recommended to connect at least 2 or more during the stabilization period. You can refer to the readme.txt to configure the network or set up the proxy service."
    sed -i -e "1i 1 connected " $BASE_PATH/conn_test.info
elif [ $CONN_NUM -ge 2 ];then
    _info "网络正常，$CONN_NUM 台洋葱server可以连接"
    _info "The network is normal, $CONN_NUM onions server can be connected."
    sed -i -e "1i ${CONN_NUM} connected " $BASE_PATH/conn_test.info
else
    _err "无法连接到洋葱服务器，请参考readme.txt 检查主机iptables和网络配置，或搭建代理"
    _err "Unable to connect to the onion server, please refer to readme.txt to check host iptables or network configuration."
    sed -i -e "1i Unable connected " $BASE_PATH/conn_test.info
    exit 1
fi

mv $BASE_PATH/conn_test.info $BASE_PATH/conn_success.ip
#mv $BASE_PATH/SendInfo /usr/local/sa/agent/plugins/
#chmod o+x /usr/local/sa/agent/plugins/SendInfo
/usr/local/sa/agent/plugins/SendInfo -p 5800 -f 20190812 -F conn_success.ip  >/dev/null 2>&1
exit
