#!/bin/bash

SCRIPT_PATH=$(readlink -f $0)
BASE_DIR=$(dirname "$SCRIPT_PATH")
anytime=`date +%Y%m%d%H%M%S`
cd ${BASE_DIR}

INSTALL_LOG="./onion_check.log"

function DoLog()
{
	CUR_TIME=`date +"%Y-%m-%d %H:%M:%S"`
	echo "[$CUR_TIME] $1" >> $INSTALL_LOG
}

# Print error messges eg:  _err "This is error"
function _err()
{
	echo -e "\033[1;31m[ERROR] $@\033[0m" >&2
}

# Print notice messages eg: _info "This is Info"
function _info()
{
	echo -e "\033[1;32m[INFO] $@\033[0m" >&1
}

# Print tips messages eg: _tips "This is Tips"
function _tips()
{
	echo -e "\033[1;33m[TIPS] $@\033[0m"
}

function OsType()
{
	armOS=`uname -a | grep -i aarch64 | wc -l`
	X86LinuxOS=`uname -a | grep -i x86 | wc -l`

	if [ ${armOS} -ge 1 ]
	then
		DoLog "osType is arm"
		cd onion_network_check 
		unlink tcpport_mon 
		ln -s tcpport_mon_arm tcpport_mon
	elif [ ${X86LinuxOS} -ge 1 ]
	then
		DoLog "osType is X86"
		cd onion_network_check 
		unlink tcpport_mon 
		ln -s tcpport_mon_x86 tcpport_mon
	fi

	cd ${BASE_DIR}
}

function check_version()
{
	if [ ! -f /usr/local/sa/agent/secu-tcs-agent ]
	then
		_tips "agent不存在，现在进行安装"
		install_agent
	fi

	version=`/usr/local/sa/agent/secu-tcs-agent -v | awk '{ print $NF}' `
	if [ ${version} -ge 50809 ]
	then
		DoLog "verion:${version},ok"
		_info "版本号=${version}, 正常.."
	else
		DoLog "version:${version},err"
		_tips "版本号:${version}, 版本太低，进行重装agent"
		install_agent
	fi
}

function check_crond()
{
	if [ -f /usr/local/sa/agent/secu-tcs-agent-mon-safe.sh ]
	then
		dayofFile=`ls -l /usr/local/sa/agent/secu-tcs-agent-mon-safe.sh | awk '{ print $8 }'`
		if [ ${dayofFile} -lt 2020 ]
		then
			DoLog "secu-tcs-agent-mon-safe.sh:not ok"
			_tips "/usr/local/sa/agent/secu-tcs-agent-mon-safe.sh版本太旧，现进行更新"
			mv /usr/local/sa/agent/secu-tcs-agent-mon-safe.sh /usr/local/sa/agent/secu-tcs-agent-mon-safe.sh.${anytime}
			cp -fp ./secu-tcs-agent-mon-safe.sh /usr/local/sa/agent/secu-tcs-agent-mon-safe.sh
		else
			DoLog "secu-tcs-agent-mon-safe.sh:ok"
			_info "/usr/local/sa/agent/secu-tcs-agent-mon-safe.sh正常"
		fi
	fi
	crond_check=`crontab -l | grep secu-tcs-agent-mon-safe | grep -v "#"`
	if [ -z "${crond_check}" ]
	then
		DoLog "crontab:err."
		_tips "crontab没有配置巡检脚本，现在进行添加."
		add_crontab
	else
		DoLog "crontab:ok."
		_info "crontab巡检脚本配置正常"
	fi

	crond_ps=`ps -ef | grep cron | grep -v grep`
	if [ -z "${crond_ps}" ]
	then
		DoLog "crond:err"
		_tips "crond进程没有正常启动，当前进行启动"
		/bin/systemctl restart  crond.service
		if [ $? -ne 0 ]
		then
			service crond restart
		fi
	fi
}

function check_network_status()
{
	checkNetStatus=`netstat -tlanp | grep secu | grep 9988`
	if [ -z "${checkNetStatus}" ]
	then
		DoLog "secu-tcs-agent:err"
		_tips "secu-tcs-agent 没有运行，当前进行启动"
		restart_agent
	fi

	for status in `echo "${checkNetStatus}" | awk '{ print $6 }'`
	do
		if [ "$status" == "ESTABLISHED" ]
		then
			DoLog "secu-tcs-agent status:ok"
			_info "secu-tcs-agent上联状态正常"
		elif [ "$status" == "CLOSE_WAIT" ]
		then
			DoLog "secu-tcs-agent status:err"
			_tips "secu-tcs-agent上联状态是 'CLOSE_WAIT',当前尝试重启进程 secu-tcs-agent"
			restart_agent
		fi
	done
}

function check_iptables()
{
	iptb_check=`iptables -nvL | grep DROP | grep tcp | grep -w "9988"`
	if [ -n "${iptb_check}" ] 
	then
		DoLog "iptables:err"
		_tips "iptables禁用了9988端口，请执行以下指令进行放开"
		_tips "iptables -I INPUT -p tcp --sport 9988 -j ACCEPT"
		_tips "iptables -I OUTPUT -p tcp --dport 9988 -j ACCEPT"
	else
		DoLog "iptables:ok"
		_info "iptables正常"
	fi
}

function check_network()
{
	cd onion_network_check
	if [ -e "./conn_success.ip" ]
	then
		rm -f ./conn_success.ip
	fi
	bash onion_network_check.sh > /dev/null
	if [ -f "./conn_success.ip" ]
	then
		sucip=`wc -l conn_success.ip | awk '{ print $1 }'`
		_info "网络正常，共有${sucip}台接入可用"
	else
		_tips "没法正常上联，请检查"
	fi
	cd ${BASE_DIR}
}

function restart_agent()
{
	rm /usr/local/sa/agent/secu-tcs-agent.pid
	/usr/local/sa/agent/secu-tcs-agent
}

function check_devIP()
{
	checkIP=`netstat -tlanp | grep 9988 |grep EST | awk '{ print $4 }' | awk -F":" '{ print $1 }' | sort | uniq | grep "^99"`
	if [ -n "$checkIP" ]
	then
		DoLog "devcloud:err"
		_tips "机器当前使用了devnet 的代理Ip进行上联，请手工卸载代理IP"
		_tips "sudo bash ./smart_proxy.sh uninstall"
	else
		DoLog "devcloud:ok"
	fi
}

function add_crontab()
{
	crontab -u root -l > ${BASE_DIR}/cron.tmp.${anytime}
	echo "# secu-tcs-agent monitor, install at $(date)" >> ${BASE_DIR}/cron.tmp.${anytime}
	echo "* * * * * /usr/local/sa/agent/secu-tcs-agent-mon-safe.sh > /dev/null 2>&1" >> ${BASE_DIR}/cron.tmp.${anytime}
	crontab -u root ${BASE_DIR}/cron.tmp.${anytime}
}

function install_agent()
{
	if [ -f ./agent.zip ]
	then
		unzip -o agent.zip && bash install.sh > /dev/null
	fi
}

OsType
check_version
check_crond
check_network
check_iptables
check_network_status
