#!/bin/bash

INSTALL_LOG="./onion_install.log"

function DoLog()
{
	CUR_TIME=`date +"%Y-%m-%d %H:%M:%S"`
	echo "[$CUR_TIME] $1" >> $INSTALL_LOG
}

function check_onion_agent()
{
	agentVer=`/usr/local/sa/agent/secu-tcs-agent -v | awk '{ print $NF }'`
	psCheck=`ps -ef |grep secu-tcs-agent | grep -v grep | wc -l `
	DoLog "onion agent cur version is ${agentVer} "
	if [ ${agentVer} -gt 50809 -a ${psCheck} -ge 1 ]
	then
		DoLog "onion Agent has already installed ! exist ..."
		exit 0
	fi
}

function OsType()
{
	armOS=`uname -a | grep -i aarch64 | wc -l`
	X86LinuxOS=`uname -a | grep -i x86 | wc -l`
	ppcOS=`uname -a | grep -i ppc64le | wc -l`

	if [ ${armOS} -ge 1 ]
	then
		DoLog "osType is arm"
		echo 2
	elif [ ${ppcOS} -ge 1 ]
	then
		DoLog "osType is power pc"
		echo 3
	elif [ ${X86LinuxOS} -ge 1 ]
	then
		DoLog "osType is X86"
		echo 1
	else
		DoLog "neither X86 or arm OS ,onion Agent cannot install. exit ..."
		echo 1
	fi
}

function installOnionAgent()
{
	os_type=$1
	if [ $os_type -eq 1 ]
	then
		cd ./x86
		DoLog "unzip agent.zip and install "
		unzip -o agent.zip && bash install.sh
	elif [ $os_type -eq 2 ]
	then
		cd ./arm
		DoLog "unzip agent.zip and install "
		unzip -o agent.zip && bash install.sh
	elif [ $os_type -eq 3 ]
	then
		cd ./power
		DoLog "unzip agent.zip and install "
		unzip -o agent.zip && bash install.sh
	else
		DoLog "unknown os type.install x86 pkg"
		cd ./x86
		DoLog "unzip agent.zip and install "
		unzip -o agent.zip && bash install.sh
	fi
}

check_onion_agent
os_type=`OsType`
installOnionAgent ${os_type}
